<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\HangoutsChat;

class GoogleAppsCardV1PlatformDataSource extends \Google\Model
{
  /**
   * @var string
   */
  public $commonDataSource;
  protected $hostAppDataSourceType = HostAppDataSourceMarkup::class;
  protected $hostAppDataSourceDataType = '';

  /**
   * @param string
   */
  public function setCommonDataSource($commonDataSource)
  {
    $this->commonDataSource = $commonDataSource;
  }
  /**
   * @return string
   */
  public function getCommonDataSource()
  {
    return $this->commonDataSource;
  }
  /**
   * @param HostAppDataSourceMarkup
   */
  public function setHostAppDataSource(HostAppDataSourceMarkup $hostAppDataSource)
  {
    $this->hostAppDataSource = $hostAppDataSource;
  }
  /**
   * @return HostAppDataSourceMarkup
   */
  public function getHostAppDataSource()
  {
    return $this->hostAppDataSource;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleAppsCardV1PlatformDataSource::class, 'Google_Service_HangoutsChat_GoogleAppsCardV1PlatformDataSource');
